//Author: DiddiZ
//Date: 2011-02-28

package de.diddiz.Uptime;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class Uptime extends JavaPlugin
{
    private long serverStart = System.currentTimeMillis();

	@Override
	public void onEnable() {
		getServer().getLogger().info("Uptime v" + getDescription().getVersion() + " by DiddiZ enabled");
	}
    
	@Override
	public void onDisable()	{
		getServer().getLogger().info("Uptime disabled");
	}
	
	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args)	{
		String commandName = cmd.getName().toLowerCase();
		if (commandName.equals("uptime")) {
			sender.sendMessage(GetUptimeString());
			return true;
		} else if (commandName.equals("sayuptime")) {
			if (sender.isOp()) {
				getServer().getLogger().info("[CONSOLE] " + GetUptimeString());
				getServer().broadcastMessage("d[Server] " + GetUptimeString());
			} else
				sender.sendMessage("You are not allowed to do that");
			return true;
		} else
			return false;
	}
	
	private String GetUptimeString() {
		long diff = System.currentTimeMillis() - serverStart;
		return "Uptime: " + (int)(diff / 86400000) + "d " + (int)(diff / 3600000 % 24) + "h " + (int)(diff / 60000 % 60) + "m " + (int)(diff / 1000 % 60) + "s";
	}
}